;****************************************************************************
;*                                                                          *
;* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY    *
;* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE      *
;* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR    *
;* PURPOSE.                                                                 *
;*                                                                          *
;* Copyright(C) 1997-98 by PSH //UCL.                                       *
;*                                                                          *
;****************************************************************************
;*                                                                          *
;* This is File I/O functions for Full Version of Soft-Pro HASP Emulator    *
;*                                                                          *
;****************************************************************************

	.386p

	.XLIST

include		local.inc			; For VxD

VxD_CODE_SEG					; VxD Code Segment Here


StartCDecl	EMUCreateFile			; Open or Create File

		mov edx,[esp+4]			; File Name

		cmp dword ptr [esp+8],1		; Create ?
		jne OpenFile
	
		mov ah,3Ch			; Create File fn
		xor ecx,ecx			; Attribute
		VxDInt	21h			; Call Int21
	
		jc ErrorOpen			; Error ?
                                       
		ret				; Return AX==handle

OpenFile:					; Open File
	
		mov ax,3D02h
		VxDInt	21h			; Call Int21

		jc ErrorOpen			; Error

		ret				; Return AX==handle

ErrorOpen:

		xor ax,ax			; Error. AX==0
		ret

EndCDecl	EMUCreateFile


StartCDecl	EMUReadFile			; Read File

		mov ax,4200h			; Set File Ptr

		push dword ptr [esp+12]		; Read Offset
		pop dx
		pop cx

		mov ebx,[esp+4]			; Handle

		VxDInt 21h                      ; Call Int21
		jc ErrorRead			; Error ?

		mov ah,3Fh			; Read From File
		mov ecx,[esp+8]			; Bytes
		mov edx,[esp+16]		; Buffer
		VxDInt 21h			; Call Int21
		jc ErrorRead			; Error

		ret				; Return. AX==bytes readed

ErrorRead:                                      ; Error
		mov eax,-1			; Return AX==-1
		ret
EndCDecl	EMUReadFile


StartCDecl	EMUWriteFile			; Write File


		mov ax,4200h			; Set File Ptr

		push dword ptr [esp+12]		; Read Offset
		pop dx
		pop cx

		mov ebx,[esp+4]			; Handle

		VxDInt 21h                      ; Call Int21
		jc ErrorWrite			; Error ?


		mov ah,40h			; Write To File
		mov ecx,[esp+8]			; Bytes
		mov edx,[esp+16]		; Buffer
		VxDInt 21h			; Call Int21
		jc ErrorWrite			; Error ?

		ret				; Return. AX==bytes writed

ErrorWrite:                     		; Error
		mov eax,-1			; Return. AX==-1
		ret
EndCDecl	EMUWriteFile


StartCDecl	EMUCloseFile			; Close File

		mov ah,3Eh
		mov ebx,[esp+4]			; Handle
		VxDInt	21h
		jc NotClosed			; Erorr ?

		xor eax,eax			Return. AX==0
		ret

NotClosed:	mov eax,-1			; Erorr
		ret				; Return. AX==-1

EndCDecl	EMUCloseFile

VxD_CODE_ENDS
		
END


